<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage core
* @filesource
*//** */

require_once APPPATH.'helpers/environment_helper.php'; //can't rely on load if we're getting an error in the early loading process.

/**
* @package direct-as-a-service
* @subpackage core
*/
class DPII_Exceptions extends CI_Exceptions {
	var $backtrace;
	//the CI code removes identifying info for security, but this is not helpful to us.  we don't show backtraces on prod, so we want full info on dev.
	var $original_filepath; 	
	
	
	/**
	* On dev, bypass the usual CI_Exception::show_error method and show a php error with a backtrace instead.
	*/
	function show_error($heading, $message, $template = 'error_general', $status_code = 500){
		if($template == 'error_general' && is_on_local()){ //only work out a backtrace if we're in a local development environment
			$this->backtrace = $this->backtrace();
			global $EXCEPTION_OFFSET;
			$EXCEPTION_OFFSET = $EXCEPTION_OFFSET + 1;
			trigger_error($message);
		}

		return parent::show_error($heading, $message, $template, $status_code);
	}
	
	/**
	* Sets up a backtrace for the error message to display & adjusts for any error messages triggered through multiple layers of code.
	* If this an error generated by {@link Error_helper} or if we re-triggered the error within this class,
	* the filename and number will no longer reflect the original trigger point.  This method parses the 
	* backtrace to determine the fileline and number at which the error was originally triggered.
	*/
	function show_php_error($severity, $message, $filepath, $line){	
#TODO better way?  I hate globals.		
		global $EXCEPTION_OFFSET;
		
		if(is_on_local()){ //only work out a backtrace if we're in a local development environment	
			$this->backtrace = $this->backtrace();				
			if(isset($EXCEPTION_OFFSET) && !empty($EXCEPTION_OFFSET) && is_numeric($EXCEPTION_OFFSET) && $EXCEPTION_OFFSET > 0){
				$target = $this->backtrace[count($this->backtrace) - 1 - $EXCEPTION_OFFSET];
				if(!empty($target) && array_key_exists('file', $target) && array_key_exists('line', $target)){
					$line = $target['line'];
					$filepath = $target['file'];
				}
			}	
			
			$this->original_filepath = $filepath;
		}
		
		parent::show_php_error($severity, $message, $filepath, $line);
	
		if (config_item('log_threshold') == 0)	
			$EXCEPTION_OFFSET = 0; //we'll still need this EXCEPTION_OFFSET if we're going to log the error, but otherwise, we should wipe it.
	}
	
	/**
	* If the Error_helper triggered this function, use the $EXCEPTION_OFFSET to figure out which part of the code used the error helper.
	*/
	function log_exception($severity, $message, $filepath, $line){
		global $EXCEPTION_OFFSET;
		
		if(is_on_local()){ //only work out a backtrace if we're in a local development environment
			if(isset($EXCEPTION_OFFSET) && !empty($EXCEPTION_OFFSET) && is_numeric($EXCEPTION_OFFSET) && $EXCEPTION_OFFSET > 0){
				$backtrace = $this->backtrace($called_from = 'log_exception'); //don't set the class var, as we won't be needing this version of it again
				$target = $backtrace[count($backtrace) - 1 - $EXCEPTION_OFFSET];
				if(!empty($target) && array_key_exists('file', $target) && array_key_exists('line', $target)){
					$line = $target['line'];
					$filepath = $target['file'];
				}
			}	
			$this->original_filepath = $filepath;
		}
		
		parent::log_exception($severity, $message, $filepath, $line);
		$EXCEPTION_OFFSET = 0; //logging is the last thing we do, so be sure to reset the $EXCEPTION_OFFSET.
	}	
	
	/**
	* Sets up a backtrace to be displayed by the error message.
	* Backtrace is generated by PHP's {@link debug_backtrace()} & formatted for display purposes.
	*/
	function backtrace($called_from = 'show_php_error'){			
		$backtrace = debug_backtrace();
		$post_trigger_error_functions = array($called_from, 'backtrace', 'MY_Exceptions', 'load_class', '_exception_handler', 'trigger_error');		
		
#TODO -- come back to this and rethink the way this is working when you've had more of a chance to figure out if this is working.
		foreach($backtrace as $row => $data){
			if(!in_array($data['function'], $post_trigger_error_functions) || $data['function'] == 'trigger_error') break; 
			if(in_array($data['function'], $post_trigger_error_functions)) unset($backtrace[$row]); 
		} 
				
		foreach($backtrace as $row=>&$data){ 
			unset($data['object']);	//not necessary, just makes it easier to see things when you're debugging
			if(!isset($data['file'])) $data['file'] = false;
						
			$data['function_for_display'] = $data['function'];
			if(!empty($data['class'])){
				$data['function_for_display'] = $data['class'].$data['type'].$data['function'];
			}
			
			$data['short_file'] = '';
			if(is_string($data['file'])){
				$last_slash = strrpos($data['file'], '/');
				$data['short_file'] = '..'.substr($data['file'], $last_slash);
			}
		}
		
		$backtrace = array_reverse($backtrace);		
		$this->backtrace = $backtrace;
		return $this->backtrace;
	}


}
// END Exceptions Class

/* End of file Exceptions.php */
/* Location: ./system/libraries/Exceptions.php */